/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Entity.Projectiles;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.particle.ParticleOrb;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySunstrike;
import com.hoshino.cti.util.ISunStrikeMixin;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class HomingSunStrike
extends EntitySunstrike {
    @Nullable
    public LivingEntity homingEntity;
    public LivingEntity owner;
    public float damage = 16.0f;
    private static final EntityDataAccessor<Integer> STRIKE_COUNT = SynchedEntityData.m_135353_(HomingSunStrike.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public HomingSunStrike(EntityType<? extends EntitySunstrike> type, Level world) {
        super(type, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STRIKE_COUNT, (Object)0);
    }

    public void setStrikeCount(int count) {
        this.f_19804_.m_135381_(STRIKE_COUNT, (Object)count);
    }

    public int getStrikeCount() {
        return (Integer)this.f_19804_.m_135370_(STRIKE_COUNT);
    }

    public void m_8119_() {
        this.m_6075_();
        this.setPrevStrikeTime(this.getStrikeTime());
        if (this.f_19853_.f_46443_) {
            if (this.getStrikeTime() == 0) {
                MowziesMobs.PROXY.playSunstrikeSound((EntitySunstrike)this);
            } else if (this.getStrikeTime() < 25) {
                float time = this.getStrikeTime(1.0f);
                int timeBonus = (int)(time * 5.0f);
                int orbCount = this.f_19796_.m_188503_(4 + timeBonus) + timeBonus + 1;
                while (orbCount-- > 0) {
                    float theta = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                    float r = this.f_19796_.m_188501_() * 1.6999999f + 0.2f;
                    float ox = r * Mth.m_14089_((float)theta);
                    float oz = r * Mth.m_14031_((float)theta);
                    float oy = this.f_19796_.m_188501_() * (time * 6.0f - 0.1f) + 0.1f;
                    this.f_19853_.m_7106_((ParticleOptions)new ParticleOrb.OrbData((float)this.m_20185_(), (float)this.m_20189_()), this.m_20185_() + (double)ox, this.m_20186_() + (double)oy, this.m_20189_() + (double)oz, 0.0, 0.0, 0.0);
                }
            } else if (this.getStrikeTime() > 35) {
                this.smolder();
                if (this.getStrikeTime() > 43 && this.getStrikeCount() > 0) {
                    this.setStrikeCount(this.getStrikeCount() - 1);
                    this.setStrikeTime(34);
                    this.setPrevStrikeTime(33);
                }
            } else if (this.getStrikeTime() == 35) {
                this.spawnExplosionParticles(10);
            }
        } else {
            if (this.getStrikeTime() < 44) {
                this.moveDownToGround();
            }
            if (this.getStrikeTime() < 400) {
                if (this.getStrikeTime() == 35) {
                    this.damageEntityLivingBaseNearby(3.0);
                }
                if (this.getStrikeTime() > 43 && this.getStrikeCount() > 0) {
                    this.setStrikeCount(this.getStrikeCount() - 1);
                    this.setStrikeTime(34);
                    this.setPrevStrikeTime(33);
                }
            } else {
                this.m_146870_();
            }
        }
        this.setStrikeTime(this.getStrikeTime() + 1);
    }

    public int getStrikeTime() {
        return ((ISunStrikeMixin)((Object)this)).cti$getStrikeTime();
    }

    public int getPrevStrikeTime() {
        return ((ISunStrikeMixin)((Object)this)).cti$getPrevStrikeTime();
    }

    public void setStrikeTime(int i) {
        ((ISunStrikeMixin)((Object)this)).cti$setStrikeTime(i);
    }

    public void setPrevStrikeTime(int i) {
        ((ISunStrikeMixin)((Object)this)).cti$setPrevStrikeTime(i);
    }

    private void spawnExplosionParticles(int amount) {
        int i;
        for (i = 0; i < amount; ++i) {
            float yaw = (float)i * ((float)Math.PI * 2 / (float)amount);
            float vy = this.f_19796_.m_188501_() * 0.08f;
            float vx = 0.1f * Mth.m_14089_((float)yaw);
            float vz = 0.1f * Mth.m_14031_((float)yaw);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_(), (double)vx, (double)vy, (double)vz);
        }
        for (i = 0; i < amount / 2; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    private void smolder() {
        if (this.f_19796_.m_188501_() < 0.1f) {
            int amount = this.f_19796_.m_188503_(2) + 1;
            while (amount-- > 0) {
                float theta = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                float r = this.f_19796_.m_188501_() * 0.7f;
                float x = r * Mth.m_14089_((float)theta);
                float z = r * Mth.m_14031_((float)theta);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + (double)x, this.m_20186_() + 0.1, this.m_20189_() + (double)z, 0.0, 0.0, 0.0);
            }
        }
    }

    public void moveDownToGround() {
        if (this.homingEntity != null && this.homingEntity.m_21224_()) {
            this.homingEntity = null;
        }
        if (this.homingEntity == null) {
            AABB aabb = new AABB(this.m_20185_() - 8.0, this.m_20186_() - 8.0, this.m_20189_() - 8.0, this.m_20185_() + 8.0, this.m_20186_() + 8.0, this.m_20189_() + 8.0);
            this.f_19853_.m_6443_(LivingEntity.class, aabb, living -> living != this.owner && !(living instanceof Player)).stream().min((living1, living2) -> (int)((living1.m_20182_().m_82546_(this.m_20182_()).m_82553_() - living2.m_20182_().m_82546_(this.m_20182_()).m_82553_()) * 100.0)).ifPresent(living -> {
                this.homingEntity = living;
            });
        }
        if (this.homingEntity != null) {
            this.m_146884_(this.homingEntity.m_20182_());
        }
    }

    public void damageEntityLivingBaseNearby(double radius) {
        AABB aabb = new AABB(this.m_20185_() - radius, this.m_20186_() - 0.5, this.m_20189_() - radius, this.m_20185_() + radius, this.m_20186_() + 20.0, this.m_20189_() + radius);
        this.f_19853_.m_6443_(LivingEntity.class, aabb, living -> living != this.owner).forEach(living -> {
            living.f_19802_ = 0;
            living.m_6469_(DamageSource.m_19340_((Entity)this, (LivingEntity)this.homingEntity), this.damage);
            living.f_19802_ = 0;
            DamageSource fireSource = new IndirectEntityDamageSource(DamageSource.f_19305_.f_19326_, (Entity)this, (Entity)this.owner).m_19383_();
            living.m_6469_(fireSource, this.damage);
        });
    }
}

